<?php
/* --------------------------------------------------------------
 LoaderInterface.php 2020-02-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Smarty;

/**
 * Interface LoaderInterface
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
interface LoaderInterface
{
    /**
     * Loads layout data that will be assigned to smarty.
     *
     * @param Smarty $smarty
     */
    public function load(Smarty $smarty): void;
}